#include <iostream>
#include <cstdlib>
#include <cmath>
#include <vector>
#include <map>
#include <set>
#include <queue>
#include <ctime>
#include <cassert>
#include <string>
#include <cstdlib>
#include <cstring>
#include <algorithm>
#include <memory.h>

#define pb push_back
#define mp make_pair
#define fr first
#define sc second

using namespace std;

const int N = 2e5 + 10;
const int INF = 1e6;
const int T = 50;
const double eps9 = 1e-3;

struct event {
	double t;
	int type;
	event() { }
	event(double t, int type): t(t), type(type) { }
};

int x[N];
int r[N];
int n;
int cur;
pair < double, double > b[N];
vector < event > e1;
vector < event > e2;
event e[N];


bool cmp(event a, event b) {
	return a.t < b.t;
}

pair < double, double > bb[N];

int del(pair < double, double > * b, int cur) {
    for (int i = 0; i < cur; i++) {
        if (!(-INF <= b[i].fr && b[i].fr <= INF))
            while(true);
    }
	int cur1 = 0;
	for (int i = 0; i < cur; i++) {
		for (; cur1 > 0 && b[i].fr <= bb[cur1 - 1].fr ; cur1--);
		bb[cur1++] = b[i];
	}
	for (int i = 0; i < cur1 - 1; i++) {
		assert(bb[i].fr <= bb[i + 1].fr + 1);
	}
	for (int i = 0; i < cur1; i++)
		b[i] = bb[i];
	return cur1;
}

int del2(pair < double, double > * b, int cur) {
	int cur1 = n - 1;
	for (int i = cur - 1; i >= 0; i--) {
		for (; cur1 < n - 1 && b[cur1 + 1].sc <= b[i].sc; cur1++);
		b[cur1--] = b[i];
	}
	int cnt = n - 1 - cur1;
	int shift = n - cnt;	

	for (int i = 0; i < cnt; i++)
		b[i] = b[i + shift];
	
	for (int i = 0; i < cnt - 1; i++) {
		//assert(b[i].sc <= b[i + 1].sc);
	}
	return cnt;
}


bool cmpE(event a, event b) {
	return a.t < b.t;
}
//
bool check(double X) {
	cur = 0;
	for (int i = 0; i < n; i++) {
		if (r[i] <= X) continue;
		double d = sqrt(r[i] * r[i] - X * X);
		b[cur++] = mp(x[i] - d, x[i] + d);
	}

	cur = del(b, cur);	
	cur = del2(b, cur);

	//cerr << "cur: " << cur << endl;
	//rev(b, cur);


	//cur = del(b, cur);
	//c//err << "cur: " << cur << endl;
	//rev(b, cur);
	//for (int i = 0; i < cur; i++)
		//cerr << b[i].fr << " " << b[i].sc << " sum: " << b[i].fr + b[i].sc << endl;

	
	//for (int i = 0; i < cur - 1; i++) {
		//cerr << b[i].fr << " " << b[i + 1].fr << endl;
//		while (!(b[i].fr <= b[i + 1].fr + eps9));
		//assert(b[i].sc <= b[i + 1].sc + eps9);
	//}

	e1.clear();
	e2.clear();
	for (int i = 0; i < cur; i++) {
		e1.pb(event(b[i].fr, 1));
		e2.pb(event(b[i].sc, -1));
	}
	merge(e1.begin(), e1.end(), e2.begin(), e2.end(), e, cmpE);
	cur *= 2;
	//sort(b, b + cur, cmp);
	//for (int

	int cnt = 0;
	double last = 0;
	bool flag = 0;
	//for (int i = 0; i < cur; i++)
		//cerr << e[i].t << " " << e[i].type << endl;
	//cerr << endl;
	for (int i = 0; i < cur; i++) {
		auto x = e[i];
		if (x.type == 1) {
			cnt++;
			if (cnt == 1)
				last = x.t;
		}
		if (x.type == -1) {
			cnt--;
			if (cnt == 0 && x.t - last >= X * 2)
				flag = 1;
		}
		//assert(cnt >= 0);
	}
	//assert(cnt == 0);
	return flag;
}



double solve() {
	double t = 0;
	for (int i = 0; i < n; i++)
		t = max(t, (double)r[i]);
	t *= sqrt(2.0);
	double l = 0;
	double r = INF;
	//cerr << check(1) << endl;
	//return 0;
	for (int t = 0; t < T; t++) {
		if (check((l + r) / 2))
			l = (l + r) / 2;
		else
			r = (l + r) / 2;
	}
	//assert(t <= l * 2 + eps9);
	//cerr << "t l: " << t << "     " << endl;
	//cerr << l * 2 << endl;
	return l * 2;		
}

vector < pair < int, int > > yy;

void genTest() {
	n = 50;
	//printf("%d\n", n);
	int T = 5000;
	yy.clear();
	for (int j = 0; j < n; j++)
		yy.pb(mp(rand() % T, rand() % T));

	sort(yy.begin(), yy.end());
	for (int i = 0; i < n; i++)
		x[i] = yy[i].fr;
	for (int i = 0; i < n; i++)
		r[i] = yy[i].sc;			
	//for (int j = 0; j < n; j++)
	//	printf("%d %d\n", x[j].fr, x[j].sc);
}

void printTest() {
	printf("%d\n", n);
	for (int i = 0; i < n; i++)
		printf("%d %d\n", x[i], r[i]);
	printf("0\n");
}

void stress() {
	for (int t = 0; t < 10000; t++) {
		cerr << "test id: " << t << endl;
		genTest();		
		//cerr << x[n/2] << endl;
		//printTest();
		solve();
	}
}


int main() {
#ifdef DEBUG
	freopen("in", "r", stdin);
#endif
	if (1) {
		while (true) {
			scanf("%d", &n);
			if (n == 0) return 0;
			for (int i = 0; i < n; i++)
				scanf("%d%d", &x[i], &r[i]);
			printf("%.15lf\n", solve());
			//printf("%.15lf\n", l * 2);
		}
	}
	else {
		stress();
	}
	//cerr << endl;
	//cerr << clock() * 1.0 / CLOCKS_PER_SEC << endl;
	return 0;
}

